// Dice roller & form behavior
document.addEventListener('DOMContentLoaded', () => {
  const rollBtn = document.getElementById('roll-btn');
  const dieSelect = document.getElementById('die-type');
  const resultBox = document.getElementById('result');
  const historyList = document.getElementById('history');

  function rollDie(sides){
    return Math.floor(Math.random()*sides) + 1;
  }

  rollBtn?.addEventListener('click', (e)=>{
    const sides = parseInt(dieSelect.value,10) || 6;
    const val = rollDie(sides);
    resultBox.textContent = val;
    resultBox.style.transform = 'scale(1.12)';
    setTimeout(()=> resultBox.style.transform = '', 180);
    const item = document.createElement('div');
    const now = new Date().toLocaleTimeString();
    item.textContent = `${sides}-sided rolled: ${val} at ${now}`;
    historyList.prepend(item);
    // store short history in localStorage
    const hist = JSON.parse(localStorage.getItem('diceHistory')||'[]');
    hist.unshift({sides,val,t:new Date().toISOString()});
    localStorage.setItem('diceHistory', JSON.stringify(hist.slice(0,20)));
  });

  // populate history from storage
  const stored = JSON.parse(localStorage.getItem('diceHistory')||'[]');
  stored.forEach(entry=>{
    const item = document.createElement('div');
    item.textContent = `${entry.sides}-sided rolled: ${entry.val} at ${new Date(entry.t).toLocaleString()}`;
    historyList.appendChild(item);
  });

  // Contact form: basic client-side check and show success message
  const contactForm = document.getElementById('contact-form');
  contactForm?.addEventListener('submit', (e)=>{
    e.preventDefault();
    const required = contactForm.querySelectorAll('[required]');
    let ok = true;
    required.forEach(inp=>{ if(!inp.value.trim()) ok = false; });
    if(!ok){
      alert('Please fill the required fields.');
      return;
    }
    // show non-functional success message
    const msg = document.createElement('div');
    msg.className = 'kv';
    msg.textContent = 'Thanks! Your form was submitted (demo-only).';
    contactForm.appendChild(msg);
    contactForm.reset();
  });
});